function [prop_out] = find_imgprop2(varargin)
%This function uses imreginalmax to find the local max, and imhmax to
%threashold the maximas, then calculate the centroid from the local max.
%Differs from find_imgprop in that it opens each image stack sequentially.
%Synatax:   [prop_out] = find_imgprop('stks',array,'theshold',0.5,'type',
%                   {'area','MeanIntensity'})
%Input:     'stks' = stacks to be processed. in a horizontal cell array.(no
%                    longer supported, if you want this roll back to
%                    version 1.5)
%           'threshold' = the value should be between [0 1], and only 
%               maxima above the desired level will be counted. 
%               Default = 0.1 or 10%
%           type = a cell array to cell strings each a property value.
%               Current accepted Values are:
%               'Area' = the area of the delineated regions
%               'Centroid' = Centroids of the region
%               'WeightedCentroid' = the Intensity Weighted Centroids
%               'PixelIdxList' = the pixel list in matrix indices
%               'PixelList' = the pixel list in cartesian
%               'PixelValues' = the Intensity of the pixels
%               'MaxIntensity' = the max pixel intensity in the region
%               'MinIntensity' = the min pixel intensity in the region
%               'MeanIntensity' = the mean pixel intensity of the region
%               default = MeanIntensity
%               'VoxelNumber' = the number of pixels in the puncta
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements.
%Output:    prop_out = a structure with each field named after the
%               property you are seeking.

[threshold,stks_ch_names,channel_paths,type,norm,filterindex] = parse(varargin);

%matlabpool
%lets get straight on calculating the local max
for i = 1:size(stks_ch_names,2)
    %open the stack, no need to cell mode
    %warning('OFF')      %the progress bars will trigger warnings in parallel mode.
    [stks] = stack_gui('filename',stks_ch_names{1,i},'pathname',channel_paths,'filterindex',filterindex);
    %warning('ON')
    stk_tmp = stks;        %copy the stack for manipulation
    if norm
        stk_tmp = imnorm(stk_tmp);    %normalize the image so that the top and bottom 1% reside in the top and bottom range of the bit depth.
    end
    stk_bw = false(size(stk_tmp));
    for j = 1:size(stks,3)     %make the stk Black & White
        stk_bw(:,:,j) = im2bw(stk_tmp(:,:,j),threshold);
    end
    % find all the desired image properties
    for j = 1:size(type,2)
        switch type{j}
            case {'Area','area'}
                prop_tmp = regionprops(stk_bw,'Area');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'PixelIdxList','pixelidlist'}
                prop_tmp = regionprops(stk_bw,'PixelIdxList');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'PixelList','pixellist'}
                prop_tmp = regionprops(stk_bw,'PixelList');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'Centroid','centroid'}
                prop_tmp = regionprops(stk_bw,'Centroid');  %find centroid
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'WeightedCentroid','weightedcentroid'}
                prop_tmp = regionprops(stk_bw,stks,'WeightedCentroid');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'PixelValues','pixelvalues'}
                prop_tmp = regionprops(stk_bw,stks,'PixelValues');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'MaxIntensity','maxintensity'}
                prop_tmp = regionprops(stk_bw,stks,'MaxIntensity');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'MinIntensity','minintensity'}
                prop_tmp = regionprops(stk_bw,stks,'MinIntensity');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'MeanIntensity','meanintensity'}
                prop_tmp = regionprops(stk_bw,stks,'MeanIntensity');
%                 prop_tmp = struct2cell(prop_tmp)';
%                 prop_tmp = cell2mat(prop_tmp);
            case {'VoxelNumber','voxelnumber'}
                prop_tmp = regionprops(stk_bw,'PixelIdxList');      %get the list of pixels
                for l = 1:size(prop_tmp,1); prop_tmp(l).(type{j}) = size(prop_tmp(l).PixelIdxList,1); end  %calculate the number of Pixels
                prop_tmp = rmfield(prop_tmp,'PixelIdxList');        %remove the unnecessary field
            otherwise
                error(['Unrecognized Image Property Request: ',type{j}]);
        end
        %output the structure as a matrix for easy digestion
        prop_tmp = struct2cell(prop_tmp)';
        prop_tmp = cell2mat(prop_tmp);
        prop_out(i).(type{j}) = prop_tmp;      %dynamic struct field output
        prop_tmp = [];
    end
end

%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end

%ok now find the points & the brightness
mkdir(channel_paths,'improp');      %create output directory
for i = 1:size(stks_ch_names,2)
    mkdir([channel_paths,'improp'],stks_ch_names{1,i}(1:end-4));
    for j = 1:size(type,2)
        data_exp = dataset(prop_out(i).(type{j}));               %to export you need to make the data a dataset.
        %now save the files
        %export(xls_exp,'XLSfile',[[channel_paths,'improp',slash,stks_ch_names{1,i}(1:end-4),slash],[type{2},'.xls']]);
        export(data_exp,'File',[[channel_paths,'improp',slash,stks_ch_names{1,i}(1:end-4),slash],[type{j},'.csv']],'delimiter',',')
        %clear data
        data_exp = [];
    end
end
%matlabpool close

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [threshold,stks_ch_names,channel_paths,type,norm,filterindex] = parse(input)

threshold = 0.1;    
type = 'MeanIntensity';
norm = 1;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'threshold'
                    threshold = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the stacks you want to open
[stks_ch_names,channel_paths,filterindex] = uigetfile2({'*.tif','TIFF files (*.tif)';...
    '*.jpg','Jpeg files (*.jpg)';'*.gif','GIF files (*.gif)';...
    '*.bmp','Bitmap files (*.bmp)';'*.mat','Mat files (*.mat)';},'Open Stack','Multiselect','on');

%make sure the file names are in a cell array
if ~iscell(stks_ch_names)
    stks_ch_names = {stks_ch_names};
end